import pandas


def collapse_dataframe(dataframe, indexname="datetime"):
    # Rename the index s.t. it will be inserted with that column name later.
    dataframe = dataframe.rename_axis(indexname)
    # Will contain duplicate date indices.
    dataframe = pandas.concat([group[toplevel] for toplevel, group in
                               dataframe.groupby(level=0, axis='columns')])
    # Reset index to make the duplicate date indices into a column
    dataframe.reset_index(inplace=True)
    return dataframe


def correlate(dataframe, column="power_use"):
    correlations = pandas.DataFrame()
    correlations["Pearson"] = dataframe.corr(method='pearson')[column]
    correlations["Kendall"] = dataframe.corr(method='kendall')[column]
    correlations["Spearman"] = dataframe.corr(method='spearman')[column]
    return(correlations)


"""
Very rudimentary: extract dates for which the period-specified moving average
is farther than 1 standard deviation below the mean.

Be mindful of the "lead-up" sizes in the uncompressed stable encodings;
anything at the start of January is suspect.

Possible improvements:
    - Use a lower bound rolling average from a multiple (e.g. 20x) of the
      desired period.
"""
def find_absences(dataframe, window=2):
    mean = dataframe.mean()
    std = dataframe.std()
    lbound = mean - std
    rolling = dataframe.rolling(window)
    lower = rolling.mean().map(lambda x: x < lbound)
    # Recursive boolean indexing trick to get only the dates for which the
    # value is True
    dates = lower[lower].index
    return dates

